#version 330

uniform sampler2D color0Tex;
uniform sampler2D aoTex;
uniform vec4 invTexSize;
uniform float pixelRadius;

in vec4 uv;

out vec4 oColor;

float fDepth(float d0, float d1, float m0)
{
	return 1 - clamp(abs(d0 - d1)*(m0*30000 + 1000) - 1.0, 0.0, 1.0);
}

void main()
{
	float depth = textureLod(color0Tex, uv.xy, 0).z;
	
	float m = pow(1 + depth, 12);
	float d;
	vec4 sum = vec4(0.0);
	vec2 o;
	vec2 offsetUv;
	float f;
	vec4 totF = vec4(0.0);
	for (float r = -pixelRadius; r <= pixelRadius; r++) {
#if _VERTICAL
		o = vec2(0, r);
#else
		o = vec2(r, 0);
#endif
		offsetUv = o*invTexSize.xy + uv.xy;
		d = textureLod(color0Tex, offsetUv, 0).z;
		f = fDepth(depth, d, m);
		sum += f * textureLod(aoTex, offsetUv, 0);
		totF += f;
	}
	oColor = sum/totF;
}
